# 2. Part 
# Enhancing the permission system with user definded functions
def view_msg(db, userid, itemid):
    '''Checks if the user is allowed to see the msg. Returns False if the user
    is not permitted to see it else True'''
    view_id = db.msg.get(itemid, 'view')
    return check_permission(db, userid, view_id) 

def check_permission(db, userid, view_id):
    if db.config.ext['ENABLE_VIEWS']=='False':
        return True
    allowed_views = []
    groups = db.usergroup.filter(None, {'member': userid})
    for g in groups:
        allowed_views.extend(db.usergroup.get(g, 'show_msg'))
    if view_id in allowed_views:
            return True 
    return False

