# 1. Step
# Creating permissions and assigning them to user roles
vi = db.security.addPermission(name='View', 
    description='Customer is allowed to view msgs which are public',
    properties=('attribute1',
                'attribute2',
                'attributeN')
    klass='issue',
    check=view_issue)
db.security.addPermissionToRole('Customer', vi, 'issue')

vm = db.security.addPermission(name='View', 
    description='Customer is allowed to view msgs which are public',
    properties=('attribute1',
                'attribute2',
                'attributeN')
    klass='msg',
    check=view_msg)
db.security.addPermissionToRole('Customer', vm, 'msg')

# 2. Step
# Enhancing the permission system with user definded functions
def view_msg(db, userid, itemid):
    '''Checks if the user is allowed to see the msg. Returns False if the user
    is not permitted to see it else True'''
    view_id = db.msg.get(itemid, 'view')
    return check_permission(db, userid, view_id) 

def view_issue(db, userid, itemid):
 return issue_check_group(db, userid, itemid) or is_issue_creator(db, userid, itemid)

def is_issue_creator(db, userid, itemid):
    if itemid == '':
        return False
    creator = db.issue.get(itemid, 'creator')
    return creator == userid

def issue_check_group(db, userid, itemid):
    '''Checks if the user is member of either the customers, partners or
    internals group of the issue'''
    if itemid == '':
        return False 
    if db.config.ext['ENABLE_VIEWS']=='False':
        return True
    issue_groups = []
    issue_groups.append(db.issue.get(itemid, 'group_customer'))
    issue_groups.append(db.issue.get(itemid, 'group_partner'))
    issue_groups.append(db.issue.get(itemid, 'group_internal'))
    groups = db.usergroup.filter(None, {'member': userid})
    for id in groups:
        if id in issue_groups:
            return True
    return False
