#
#  spec file for Skencil
#

Summary:        python-based vector drawing program
Name:           skencil
Version:        0.6.17pre1
Release:        1
License:        LGPL, Python style
Group:          unsorted
Source:         http://prdownloads.sourceforge.net/sketch/sketch-%PACKAGE_VERSION.tar.gz
URL:            http://sketch.sourceforge.net
Packager:       Andrew Grimberg <tykeal-rpms@bardicgrove.org>

Prefix:         %{_prefix}
BuildRoot:      %{_tmppath}/%{name}-buildroot
Requires:       python >= 1.5.1, python-imaging, tkinter
BuildRequires:  python >= 1.5.1, python-imaging

%description
Skencil is an interactive X11 vector drawing program. It is written
almost completely in Python, an object oriented interpreted programming
language.

%prep
%setup
mv Pax/README Pax/README.pax
mv Pax/COPYING Pax/COPYING.pax
mv Filter/COPYING Filter/COPYING.filter
mv Filter/README Filter/README.filter
mv Tools/README Tools/README.tools
mv Tools/COPYING Tools/COPYING.tools

%build
./setup.py configure --with-nls
./setup.py build


%install
strip -S Pax/*.so
strip -S Filter/*.so
strip -S Sketch/Modules/*.so
./setup.py install --prefix=%{buildroot}%{_prefix}
%{__install} -m 755 Tools/mkfontdb.py %{buildroot}%{_bindir}

%clean
rm -rf %{buildroot}

%files
%defattr(-, root, root)
%{_libdir}/%{name}-%PACKAGE_VERSION
%{_bindir}/skencil
%{_bindir}/sketch
%{_bindir}/sk2ps
%{_bindir}/skshow
%{_bindir}/sk2ppm
%{_bindir}/skconvert
%{_bindir}/mkfontdb.py
%doc Examples
%doc Doc
%doc README INSTALL BUGS CREDITS COPYING TODO PROJECTS FAQ NEWS
%doc Pax/README.pax Pax/COPYING.pax Pax/COPYING.xext
%doc Filter/README.filter Filter/COPYING.filter
%doc Tools/README.tools Tools/COPYING.tools
%doc Misc

#%post
#for i in $(/usr/sbin/chkfontpath | %{__grep} Type1 | %{__sed} 's/[0-9]*: //g'); do
#	if [ -e $i ]; then
#		%{_bindir}/mkfontdb.py -s -o $i/std.sfd $i
#	fi
#done

%changelog
* Sun Nov 30 2003 Bernhard Herzog
- Renamed Sketch to Skencil where applicable

* Wed Jan 29 2003 Andrew Grimberg
- Updated for 0.6.15
- Changed 'Copyright' field to 'License' as Copyright appears to be deprecated

* Mon Dec 30 2002 Andrew Grimberg
- Commented out the postinstall script.  It doesn't appear to be fixing the 
  problems that I was attempting to correct.  When I can figure out the fix
  I'll get a script in to do that.

* Mon Nov 04 2002 Andrew Grimberg
- Updated the requiremnts to require python-Imaging instead of _imaging.so
- Added a requirement for tkinter to be installed
- Added build requirements of pythong >= 1.5.1 and pythong-Imaging
- Added in the mkfontdb.py tool (and associated docs) into the distributed
  rpm (wasn't doing that before)
- Added a postinstall script to build the std.sfd file (sketch fonts database
  for Type1 fonts) for each Type1 directory on the font path

* Sat Sep 21 2002 Andrew Grimberg
- Updated Packager: field for RPM build.
- Moved changelog entry from Bernhard into the proper location for build of
  rpms.  (Gotta be in descending chronological order).

* Sat Sep 21 2002 Bernhard Herzog
- Make the Packager: field empty and tweak the Version: field so that it
  can be incorporated in the sketch 0.6 source archive.

* Tue Mar 19 2002 Andrew Grimberg
- Added in sk2ppm and skconvert to the installed package
- Removed an unneeded pre variable (wasn't being properly used anyway)
- Added in a cleanup from the setup.py install call

* Sat Mar 16 2002 Andrew Grimberg
- Rebuilt .spec to support user building of package and package relocation
