/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3u-20020503-1857 (Alpha 5)
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON
/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#       endif
#endif
#else
#       define SWIGEXPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct swig_type_info {
  char  *name;                 
  void *(*converter)(void *);
  char  *str;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE
SWIGEXPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGEXPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGEXPORT(void *) SWIG_TypeCast(swig_type_info *, void *);
#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  while (s) {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      return s;
    }
    s = s->next;
  }
  return 0;
}

/* Cast a pointer (needed for C++ inheritance */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(void *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

#endif

#ifdef __cplusplus
}
#endif



/***********************************************************************
 * python.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

#include <stdlib.h>
#include "Python.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

#ifdef SWIG_NOINCLUDE

SWIGEXPORT(PyObject *)        SWIG_newvarlink();
SWIGEXPORT(void)              SWIG_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGEXPORT(int)               SWIG_ConvertPtr(PyObject *, void **, swig_type_info *, int);
SWIGEXPORT(void)              SWIG_MakePtr(char *c, void *, swig_type_info *);
SWIGEXPORT(PyObject *)        SWIG_NewPointerObj(void *, swig_type_info *);
SWIGEXPORT(void)              SWIG_InstallConstants(PyObject *d, swig_const_info constants[]);

#else

/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyString_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(0)              
  0,
  "swigvarlink",                      /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */
SWIGRUNTIME(PyObject *)
SWIG_newvarlink(void) {
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  result->vars = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}
/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  unsigned long p;
  register int d;
  swig_type_info *tc;
  char  *c;
  static PyObject *SWIG_this = 0;
  int    newref = 0;

  if (!obj || (obj == Py_None)) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyCObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  if (newref) Py_DECREF(obj);
  goto cobject;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  p = 0;
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
      if (newref) Py_DECREF(obj);
      return 0;
    } else {
      if (newref) Py_DECREF(obj);
      goto type_error;
    }
  }
  c++;
  /* Extract hex value from pointer */
  while ((d = *c)) {
    if ((d >= '0') && (d <= '9'))
      p = (p << 4) + (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      p = (p << 4) + (d - ('a'-10));
    else
      break; 
    c++;
  }
  *ptr = (void *) p;
  if (newref) Py_DECREF(obj);
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,(void*)p);
  }
  return 0;

type_error:

  if (flags) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Take a pointer and convert it to a string */
SWIGRUNTIME(void) 
SWIG_MakePtr(char *c, void *ptr, swig_type_info *ty) {
  static char hex[17] = "0123456789abcdef";
  unsigned long p, s;
  char result[32], *r; 
  r = result;
  p = (unsigned long) ptr;
  if (p > 0) {
    while (p > 0) {
      s = p & 0xf;
      *(r++) = hex[s];
      p = p >> 4;
    }
    *r = '_';
    while (r >= result)
      *(c++) = *(r--);
    strcpy (c, ty->name);
  } else {
    strcpy (c, "NULL");
  }
}

/* Create a new pointer object */
SWIGRUNTIME(PyObject *)
SWIG_NewPointerObj(void *ptr, swig_type_info *type) {
  char result[512];
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, type->name, NULL);
#else
  SWIG_MakePtr(result,ptr,type);
  robj = PyString_FromString(result);
#endif
  return robj;
}

/* Install Constants */
SWIGRUNTIME(void)
SWIG_InstallConstants(PyObject *d, swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyInt_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      obj = PyString_FromString((char *) constants[i].pvalue);
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_ShapeFile swig_types[0] 
#define  SWIGTYPE_p_SHPObject swig_types[1] 
static swig_type_info *swig_types[3];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= shapelibc.so
  ------------------------------------------------*/
#define SWIG_init    initshapelibc

#define SWIG_name    "shapelibc"


/* import the shapelib headefile. */
#include "shapefil.h"
#include "pyshapelib_api.h"
    
/*
 * Rename a few shapelib functions that are effectively methods with
 * preprocessor macros so that they have the names that swig expects
 * (e.g. the destructor of SHPObject has to be called delete_SHPObject)
 */

#define delete_SHPObject SHPDestroyObject
    
/*
 * The extents() method of SHPObject.
 *
 * Return the extents as a tuple of two 4-element lists with the min.
 * and max. values of x, y, z, m.
 */
static PyObject *
SHPObject_extents(SHPObject *object)
{
    return Py_BuildValue("[dddd][dddd]",
			 object->dfXMin, object->dfYMin, object->dfZMin,
			 object->dfMMin, 
			 object->dfXMax, object->dfYMax, object->dfZMax,
			 object->dfMMax);
}


/*
 * The vertices() method of SHPObject.
 *
 * Return the x and y coords of the vertices as a list of lists of
 * tuples.
 */

static PyObject* build_vertex_list(SHPObject *object, int index, int length);

static PyObject*
SHPObject_vertices(SHPObject *object)
{
    PyObject *result = NULL;
    PyObject *part = NULL;
    int part_idx, vertex_idx;
    int length = 0;


    if (object->nParts > 0)
    {
	/* A multipart shape. Usual for SHPT_ARC and SHPT_POLYGON */
	
	result = PyList_New(object->nParts);
	if (!result)
	    return NULL;

	for (part_idx = 0, vertex_idx = 0; part_idx < object->nParts;
	     part_idx++)
	{
	    if (part_idx < object->nParts - 1)
		length = (object->panPartStart[part_idx + 1]
			  - object->panPartStart[part_idx]);
	    else
		length = object->nVertices - object->panPartStart[part_idx];
	    
	    part = build_vertex_list(object, vertex_idx, length);
	    if (!part)
		goto fail;

	    if (PyList_SetItem(result, part_idx, part) < 0)
		goto fail;

	    vertex_idx += length;
	}
    }
    else
    {
	/* only one part. usual for SHPT_POINT */
	result = build_vertex_list(object, 0, object->nVertices);
    }

    return result;

 fail:
    Py_XDECREF(part);
    Py_DECREF(result);
    return NULL;
}


/* Return the length coordinates of the shape object starting at vertex
 * index as a Python-list of tuples. Helper function for
 * SHPObject_vertices.
 */
static PyObject*
build_vertex_list(SHPObject *object, int index, int length)
{
    int i;
    PyObject * list;
    PyObject * vertex = NULL;

    list = PyList_New(length);
    if (!list)
	return NULL;

    for (i = 0; i < length; i++, index++)
    {
	vertex = Py_BuildValue("dd", object->padfX[index],
			       object->padfY[index]);
	if (!vertex)
	    goto fail;
	if (PyList_SetItem(list, i, vertex) < 0)
	    goto fail;
    }

    return list;

 fail:
    Py_XDECREF(vertex);
    Py_DECREF(list);
    return NULL;
}





/* The constructor of SHPObject. parts is a list of lists of tuples
 * describing the parts and their vertices just likethe output of the
 * vertices() method. part_type_list is the list of part-types and may
 * be NULL. For the meaning of the part-types and their default value
 * see the Shaplib documentation.
 */
SHPObject * new_SHPObject(int type, int id, PyObject * parts,
			  PyObject * part_type_list)
{
    /* arrays to hold thex and y coordinates of the  vertices */
    double *xs = NULL, *ys = NULL;
    /* number of all vertices of all parts */
    int num_vertices;
    /* number of parts in the list parts */
    int num_parts;
    /* start index of in xs and ys of the part currently worked on */
    int part_start;
    /* array of start indices in xs and ys as expected by shapelib */
    int *part_starts = NULL;

    /* generic counter */
    int i;

    /* array of part types. holds the converted content of
     * part_type_list. Stays NULL of part_type_list is NULL
     */
    int *part_types = NULL;

    /* temporary python objects referring to the the list items being
     * worked on.
     */
    PyObject * part = NULL, *tuple = NULL;

    /* The result object */
    SHPObject *result;

    num_parts = PySequence_Length(parts);
    num_vertices = 0; 

    /* parts and part_types have to have the same lengths */
    if (part_type_list
	&& PySequence_Length(part) != PySequence_Length(part_type_list))
    {
	PyErr_SetString(PyExc_TypeError,
			"parts and part_types have to have the same lengths");
	return NULL;
    }

    /* determine how many vertices there are altogether */
    for (i = 0; i < num_parts; i++)
    {
	PyObject * part = PySequence_GetItem(parts, i);
	if (!part)
	    return NULL;
	num_vertices += PySequence_Length(part);
	Py_DECREF(part);
    }

    /* allocate the memory for the various arrays and check for memory
       errors */
    xs = malloc(num_vertices * sizeof(double));
    ys = malloc(num_vertices * sizeof(double));
    part_starts = malloc(num_parts * sizeof(int));
    if (part_type_list)
	part_types = malloc(num_parts * sizeof(int));

    if (!xs || !ys || !part_starts || (part_type_list && !part_types))
    {
	PyErr_NoMemory();
	goto fail;
    }

    /* convert the part types */
    if (part_type_list)
    {
	for (i = 0; i < num_parts; i++)
	{
	    PyObject * otype = PySequence_GetItem(part_type_list, i);
	    if (!otype)
		return NULL;
	    part_types[i] = PyInt_AsLong(otype);
	    Py_DECREF(otype);
	}
    }

    /* convert the list of parts */
    part_start = 0;
    for (i = 0; i < num_parts; i++)
    {
	int j, length;

	part = PySequence_GetItem(parts, i);
	length = PySequence_Length(part);
	part_starts[i] = part_start;

	for (j = 0; j < length; j++)
	{
	    tuple = PySequence_GetItem(part, j);
	    if (!tuple)
		goto fail;

	    if (!PyArg_ParseTuple(tuple, "dd", xs + part_start + j,
				  ys + part_start + j))
	    {
		goto fail;
	    }
	    Py_DECREF(tuple);
	    tuple = NULL;
	}
	Py_DECREF(part);
	part = NULL;
	part_start += length;
    }

    result = SHPCreateObject(type, id, num_parts, part_starts, part_types,
			     num_vertices, xs, ys, NULL, NULL);
    free(xs);
    free(ys);
    free(part_starts);
    free(part_types);
    return result;

 fail:
    free(xs);
    free(ys);
    free(part_starts);
    free(part_types);
    Py_XDECREF(part);
    Py_XDECREF(tuple);
    return NULL;
}


static PyObject* l_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyList_Check(target)) {
            o2 = target;
            target = PyList_New(0);
            PyList_Append(target, o2);
	    Py_XDECREF(o2);
        }
        PyList_Append(target,o);
	Py_XDECREF(o);
    }
    return target;
}

static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyTuple_Check(target)) {
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}

#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99

static void _SWIG_exception(int code, char *msg) {
  switch(code) {
  case SWIG_MemoryError:
    PyErr_SetString(PyExc_MemoryError,msg);
    break;
  case SWIG_IOError:
    PyErr_SetString(PyExc_IOError,msg);
    break;
  case SWIG_RuntimeError:
    PyErr_SetString(PyExc_RuntimeError,msg);
    break;
  case SWIG_IndexError:
    PyErr_SetString(PyExc_IndexError,msg);
    break;
  case SWIG_TypeError:
    PyErr_SetString(PyExc_TypeError,msg);
    break;
  case SWIG_DivisionByZero:
    PyErr_SetString(PyExc_ZeroDivisionError,msg);
    break;
  case SWIG_OverflowError:
    PyErr_SetString(PyExc_OverflowError,msg);
    break;
  case SWIG_SyntaxError:
    PyErr_SetString(PyExc_SyntaxError,msg);
    break;
  case SWIG_ValueError:
    PyErr_SetString(PyExc_ValueError,msg);
    break;
  case SWIG_SystemError:
    PyErr_SetString(PyExc_SystemError,msg);
    break;
  default:
    PyErr_SetString(PyExc_RuntimeError,msg);
    break;
  }
}

#define SWIG_exception(a,b) { _SWIG_exception(a,b); return NULL; }

    typedef struct {
	SHPHandle handle;
    } ShapeFile;

#define NOCHECK_delete_ShapeFile
#define NOCHECK_ShapeFile_close

    ShapeFile * open_ShapeFile(const char *filename, const char * mode) {
	ShapeFile * self = malloc(sizeof(ShapeFile));
	if (self)
	    self->handle = SHPOpen(filename, mode);
	return self;
    }

    ShapeFile * create_ShapeFile(const char *filename, int type) {
	ShapeFile * self = malloc(sizeof(ShapeFile));
	if (self)
	    self->handle = SHPCreate(filename, type);
	return self;
    }

    static PyShapeLibAPI the_api = {
	SHPReadObject,
	SHPDestroyObject,
	SHPCreateTree,
	SHPDestroyTree,
	SHPTreeFindLikelyShapes
    };

    PyObject * c_api() {
	return PyCObject_FromVoidPtr(&the_api, NULL);
    }
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_open(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    char *arg1 = "rb" ;
    ShapeFile *result ;
    
    if(!PyArg_ParseTuple(args,"s|s:open",&arg0,&arg1)) return NULL;
    {
        result = (ShapeFile *)open_ShapeFile((char const *)arg0,(char const *)arg1);
        ;
        if (!result)
        {
            SWIG_exception(SWIG_MemoryError, "no memory");
        }
        else if (!result->handle)
        {
            SWIG_exception(SWIG_IOError, "open_ShapeFile failed");
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_ShapeFile);
    return resultobj;
}


static PyObject *_wrap_create(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    int arg1 ;
    ShapeFile *result ;
    
    if(!PyArg_ParseTuple(args,"si:create",&arg0,&arg1)) return NULL;
    {
        result = (ShapeFile *)create_ShapeFile((char const *)arg0,arg1);
        ;
        if (!result)
        {
            SWIG_exception(SWIG_MemoryError, "no memory");
        }
        else if (!result->handle)
        {
            SWIG_exception(SWIG_IOError, "create_ShapeFile failed");
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_ShapeFile);
    return resultobj;
}


static PyObject *_wrap_c_api(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,":c_api")) return NULL;
    result = (PyObject *)c_api();
    {
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_type_name(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    int arg0 ;
    char *result ;
    
    if(!PyArg_ParseTuple(args,"i:type_name",&arg0)) return NULL;
    result = (char *)SHPTypeName(arg0);
    resultobj = PyString_FromString(result);
    return resultobj;
}


static PyObject *_wrap_part_type_name(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    int arg0 ;
    char *result ;
    
    if(!PyArg_ParseTuple(args,"i:part_type_name",&arg0)) return NULL;
    result = (char *)SHPPartTypeName(arg0);
    resultobj = PyString_FromString(result);
    return resultobj;
}


static PyObject *_wrap_SHPObject_type_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SHPObject *arg0 ;
    PyObject * argo0 =0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"O:SHPObject_type_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SHPObject,1)) == -1) return NULL;
    result = (int ) (arg0->nSHPType);
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_SHPObject_id_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SHPObject *arg0 ;
    PyObject * argo0 =0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"O:SHPObject_id_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SHPObject,1)) == -1) return NULL;
    result = (int ) (arg0->nShapeId);
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_new_SHPObject(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    int arg0 ;
    int arg1 ;
    PyObject *arg2 ;
    PyObject *arg3 = NULL ;
    PyObject * obj2  = 0 ;
    PyObject * obj3  = 0 ;
    SHPObject *result ;
    
    if(!PyArg_ParseTuple(args,"iiO|O:new_SHPObject",&arg0,&arg1,&obj2,&obj3)) return NULL;
    {
        arg2 = obj2;
    }
    if (obj3)
    {
        arg3 = obj3;
    }
    {
        result = (SHPObject *)new_SHPObject(arg0,arg1,arg2,arg3);
        ;
        if (PyErr_Occurred())
        return NULL;
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SHPObject);
    return resultobj;
}


static PyObject *_wrap_delete_SHPObject(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SHPObject *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:delete_SHPObject",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SHPObject,1)) == -1) return NULL;
    delete_SHPObject(arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SHPObject_extents(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SHPObject *arg0 ;
    PyObject * argo0 =0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"O:SHPObject_extents",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SHPObject,1)) == -1) return NULL;
    result = (PyObject *)SHPObject_extents(arg0);
    {
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_SHPObject_vertices(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SHPObject *arg0 ;
    PyObject * argo0 =0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"O:SHPObject_vertices",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SHPObject,1)) == -1) return NULL;
    result = (PyObject *)SHPObject_vertices(arg0);
    {
        resultobj = result;
    }
    return resultobj;
}


ShapeFile * new_ShapeFile(char *file,char *mode) {
    {
        ShapeFile * self = malloc(sizeof(ShapeFile));
        if (self)
        self->handle = SHPOpen(file, mode);
        return self;
    }
}


static PyObject *_wrap_new_ShapeFile(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    char *arg1 = "rb" ;
    ShapeFile *result ;
    
    if(!PyArg_ParseTuple(args,"s|s:new_ShapeFile",&arg0,&arg1)) return NULL;
    {
        result = (ShapeFile *)new_ShapeFile(arg0,arg1);
        ;
        if (!result)
        {
            SWIG_exception(SWIG_MemoryError, "no memory");
        }
        else if (!result->handle)
        {
            SWIG_exception(SWIG_IOError, "new_ShapeFile failed");
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_ShapeFile);
    return resultobj;
}


void  delete_ShapeFile(ShapeFile *self) {
    {
        if (self->handle)
        SHPClose(self->handle);
        free(self);
    }
}


static PyObject *_wrap_delete_ShapeFile(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    ShapeFile *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:delete_ShapeFile",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ShapeFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_delete_ShapeFile
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "shapefile already closed");
        #endif
    }
    delete_ShapeFile(arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


void  ShapeFile_close(ShapeFile *self) {
    {
        if (self->handle)
        {
            SHPClose(self->handle);
            self->handle = NULL;
        }
    }
}


static PyObject *_wrap_ShapeFile_close(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    ShapeFile *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:ShapeFile_close",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ShapeFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_ShapeFile_close
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "shapefile already closed");
        #endif
    }
    ShapeFile_close(arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


void  ShapeFile_info(ShapeFile *self,int *output_entities,int *output_type,double *output_min_bounds,double *output_max_bounds) {
    {
        SHPGetInfo(self->handle, output_entities, output_type,
        output_min_bounds, output_max_bounds);
    }
}


static PyObject *_wrap_ShapeFile_info(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    ShapeFile *arg0 ;
    int *arg1 ;
    int *arg2 ;
    double *arg3 ;
    double *arg4 ;
    int temp ;
    int temp0 ;
    double temp1[4] ;
    double temp2[4] ;
    PyObject * argo0 =0 ;
    
    {
        arg1 = &temp;
    }
    {
        arg2 = &temp0;
    }
    {
        arg3 = temp1;
    }
    {
        arg4 = temp2;
    }
    if(!PyArg_ParseTuple(args,"O:ShapeFile_info",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ShapeFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_ShapeFile_info
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "shapefile already closed");
        #endif
    }
    ShapeFile_info(arg0,arg1,arg2,arg3,arg4);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        PyObject *o;
        o = PyInt_FromLong((long) (*arg1));
        resultobj = t_output_helper(resultobj, o);
    }
    {
        PyObject *o;
        o = PyInt_FromLong((long) (*arg2));
        resultobj = t_output_helper(resultobj, o);
    }
    {
        PyObject * list = Py_BuildValue("[dddd]",
        arg3[0], arg3[1],
        arg3[2], arg3[3]);
        resultobj = t_output_helper(resultobj,list);
    }
    {
        PyObject * list = Py_BuildValue("[dddd]",
        arg4[0], arg4[1],
        arg4[2], arg4[3]);
        resultobj = t_output_helper(resultobj,list);
    }
    return resultobj;
}


SHPObject * ShapeFile_read_object(ShapeFile *self,int i) {
    {
        return SHPReadObject(self->handle, i);
    }
}


static PyObject *_wrap_ShapeFile_read_object(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    ShapeFile *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    SHPObject *result ;
    
    if(!PyArg_ParseTuple(args,"Oi:ShapeFile_read_object",&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ShapeFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_ShapeFile_read_object
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "shapefile already closed");
        #endif
    }
    result = (SHPObject *)ShapeFile_read_object(arg0,arg1);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SHPObject);
    return resultobj;
}


int  ShapeFile_write_object(ShapeFile *self,int iShape,SHPObject *psObject) {
    {
        return SHPWriteObject(self->handle, iShape, psObject);
    }
}


static PyObject *_wrap_ShapeFile_write_object(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    ShapeFile *arg0 ;
    int arg1 ;
    SHPObject *arg2 ;
    PyObject * argo0 =0 ;
    PyObject * argo2 =0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"OiO:ShapeFile_write_object",&argo0,&arg1,&argo2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ShapeFile,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_SHPObject,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_ShapeFile_write_object
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "shapefile already closed");
        #endif
    }
    result = (int )ShapeFile_write_object(arg0,arg1,arg2);
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


PyObject * ShapeFile_cobject(ShapeFile *self) {
    {
        return PyCObject_FromVoidPtr(self->handle, NULL);
    }
}


static PyObject *_wrap_ShapeFile_cobject(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    ShapeFile *arg0 ;
    PyObject * argo0 =0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"O:ShapeFile_cobject",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ShapeFile,1)) == -1) return NULL;
    {
        #ifndef NOCHECK_ShapeFile_cobject
        if (!arg0 || !arg0->handle)
        SWIG_exception(SWIG_TypeError, "shapefile already closed");
        #endif
    }
    result = (PyObject *)ShapeFile_cobject(arg0);
    {
        resultobj = result;
    }
    return resultobj;
}


static PyMethodDef shapelibcMethods[] = {
	 { "open", _wrap_open, METH_VARARGS },
	 { "create", _wrap_create, METH_VARARGS },
	 { "c_api", _wrap_c_api, METH_VARARGS },
	 { "type_name", _wrap_type_name, METH_VARARGS },
	 { "part_type_name", _wrap_part_type_name, METH_VARARGS },
	 { "SHPObject_type_get", _wrap_SHPObject_type_get, METH_VARARGS },
	 { "SHPObject_id_get", _wrap_SHPObject_id_get, METH_VARARGS },
	 { "new_SHPObject", _wrap_new_SHPObject, METH_VARARGS },
	 { "delete_SHPObject", _wrap_delete_SHPObject, METH_VARARGS },
	 { "SHPObject_extents", _wrap_SHPObject_extents, METH_VARARGS },
	 { "SHPObject_vertices", _wrap_SHPObject_vertices, METH_VARARGS },
	 { "new_ShapeFile", _wrap_new_ShapeFile, METH_VARARGS },
	 { "delete_ShapeFile", _wrap_delete_ShapeFile, METH_VARARGS },
	 { "ShapeFile_close", _wrap_ShapeFile_close, METH_VARARGS },
	 { "ShapeFile_info", _wrap_ShapeFile_info, METH_VARARGS },
	 { "ShapeFile_read_object", _wrap_ShapeFile_read_object, METH_VARARGS },
	 { "ShapeFile_write_object", _wrap_ShapeFile_write_object, METH_VARARGS },
	 { "ShapeFile_cobject", _wrap_ShapeFile_cobject, METH_VARARGS },
	 { NULL, NULL }
};

#ifdef __cplusplus
}
#endif

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_ShapeFile[] = {{"_p_ShapeFile", 0, "ShapeFile *"},{"_p_ShapeFile"},{0}};
static swig_type_info _swigt__p_SHPObject[] = {{"_p_SHPObject", 0, "SHPObject *"},{"_p_SHPObject"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_ShapeFile, 
_swigt__p_SHPObject, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
    { SWIG_PY_INT,     "SHPT_NULL", (long) 0, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_POINT", (long) 1, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_ARC", (long) 3, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_POLYGON", (long) 5, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_MULTIPOINT", (long) 8, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_POINTZ", (long) 11, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_ARCZ", (long) 13, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_POLYGONZ", (long) 15, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_MULTIPOINTZ", (long) 18, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_POINTM", (long) 21, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_ARCM", (long) 23, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_POLYGONM", (long) 25, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_MULTIPOINTM", (long) 28, 0, 0, 0},
    { SWIG_PY_INT,     "SHPT_MULTIPATCH", (long) 31, 0, 0, 0},
    { SWIG_PY_INT,     "SHPP_TRISTRIP", (long) 0, 0, 0, 0},
    { SWIG_PY_INT,     "SHPP_TRIFAN", (long) 1, 0, 0, 0},
    { SWIG_PY_INT,     "SHPP_OUTERRING", (long) 2, 0, 0, 0},
    { SWIG_PY_INT,     "SHPP_INNERRING", (long) 3, 0, 0, 0},
    { SWIG_PY_INT,     "SHPP_FIRSTRING", (long) 4, 0, 0, 0},
    { SWIG_PY_INT,     "SHPP_RING", (long) 5, 0, 0, 0},
{0}};

static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void) initshapelibc(void) {
    PyObject *m, *d;
    int i;
    SWIG_globals = SWIG_newvarlink();
    m = Py_InitModule("shapelibc", shapelibcMethods);
    d = PyModule_GetDict(m);
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
    }
    SWIG_InstallConstants(d,swig_const_table);
}

